% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GasolineYield.R
\docType{data}
\name{GasolineYield}
\alias{GasolineYield}
\title{Estimation of Gasoline Yields from Crude Oil}
\format{
A data frame containing 32 observations on 6 variables.
\describe{
  \item{yield}{proportion of crude oil converted to gasoline after distillation and fractionation.}
  \item{gravity}{crude oil gravity (degrees API).}
  \item{pressure}{vapor pressure of crude oil (lbf/in2).}
  \item{temp10}{temperature (degrees F) at which 10 percent of crude oil has vaporized.}
  \item{temp}{temperature (degrees F) at which all gasoline has vaporized.}
  \item{batch}{factor indicating unique batch of conditions \code{gravity},
    \code{pressure}, and \code{temp10}.}
}
}
\usage{
data("GasolineYield")
}
\description{
Proportion of crude oil converted to gasoline after the transformation processes.
}
\details{
This dataset were analyzed by Atkinson (1985) when he used a linear regression model and observed that the linear regression model failed to describe the data well, generating large residues.


The dataset contains 32 observations on the response and on the independent
variables. It was observed that there are only ten sets of values for the first three explanatory variables, so these sets served as conditions for controlled distillation. These conditions are listed in the variable \ code {batch}.

With the Needs for Closing and Needs for Certainty scales strongly correlated, the NFCCscale is a combined scale between the previous two.
}
\examples{
data("GasolineYield", package = "bayesbr")


bbr = bayesbr(yield ~ temp + batch, iter = 100,
             data = GasolineYield)

envelope(bbr, conf=0.95, sim = 100, resid.type="quantile")
}
\references{
Atkinson, A.C. (1985). \emph{Plots, Transformations and Regression: An Introduction to Graphical Methods of Diagnostic Regression Analysis}. New York: Oxford University Press.

\doi{10.18637/jss.v034.i02} Cribari-Neto, F., and Zeileis, A. (2010). Beta Regression in R.
\emph{Journal of Statistical Software}, \bold{34}(2), 1--24.

Daniel, C., and Wood, F.S. (1971).
\emph{Fitting Equations to Data}.
New York: John Wiley and Sons.

\doi{10.1080/0266476042000214501} Ferrari, S.L.P., and Cribari-Neto, F. (2004).
Beta Regression for Modeling Rates and Proportions.
\emph{Journal of Applied Statistics}, \bold{31}(7), 799--815.
}
\keyword{datasets}
