% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesPO.R
\name{bayesPO_model}
\alias{bayesPO_model}
\title{Build a model to be used in the \code{bayesPO} fitting function}
\usage{
bayesPO_model(
  po,
  intensitySelection,
  observabilitySelection,
  intensityLink = "logit",
  observabilityLink = "logit",
  initial_values = 1,
  joint_prior = prior(beta = NormalPrior(rep(0, length(intensitySelection) + 1), 10 *
    diag(length(intensitySelection) + 1)), delta = NormalPrior(rep(0,
    length(observabilitySelection) + 1), 10 * diag(length(observabilitySelection) + 1)),
    lambdaStar = GammaPrior(1e-10, 1e-10)),
  verbose = TRUE
)
}
\arguments{
\item{po}{A matrix whose rows represent the presence-only data and the
columns the covariates observed at each position.}

\item{intensitySelection}{Either a numeric or character vector and
represents the selection of covariates used for the intensity set. If
numeric it is the positions of the columns and if character, the names of
the columns.}

\item{observabilitySelection}{Either a numeric or character vector and
represents the selection of covariates used for the observability set. If
numeric it is the positions of the columns and if character, the names of
the columns.}

\item{intensityLink}{A string to inform what link function the model has
with respect to the intensity covariates. Current version accepts 'logit'.}

\item{observabilityLink}{A string to inform what link function the model has
with respect to the observabilitycovariates. Current version accepts 'logit'.}

\item{initial_values}{Either a single integer, a single
\code{bayesPO_initial-class} or a list containing
\code{bayesPO_initial-class} objects. The length of the list will inform the
model how many independent chains will be run. If an integer, that many
initial values will be randomly generated.}

\item{joint_prior}{A \code{bayesPO_prior} object.}

\item{verbose}{Set to \code{FALSE} to suppress all messages to console.}
}
\value{
A \code{bayesPO_model} object with the requested slots. It is ready
to be used in the \code{fit_bayesPO} function.
}
\description{
Constructor for \code{bayesPO_model-class} objects, built to facilitate
the use of the fitting function. The output of this function has the
necessary signature for the fit_bayesPO function to start the model fit.
}
\seealso{
\code{\link{initial}}, \code{\link{prior}} and
\code{\link{fit_bayesPO}}.
}
