% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probability_discount.R
\name{probability_discount}
\alias{probability_discount}
\alias{probability_discount,ANY-method}
\title{Bayesian Discount Prior: Comparison Between Current and Historical Data}
\usage{
probability_discount(mu = NULL, sigma = NULL, N = NULL, mu0 = NULL,
  sigma0 = NULL, N0 = NULL, number_mcmc = 10000, method = "fixed")
}
\arguments{
\item{mu}{scalar. Mean of the current data.}

\item{sigma}{scalar. Standard deviation of the current data.}

\item{N}{scalar. Number of observations of the current data.}

\item{mu0}{scalar. Mean of the historical data.}

\item{sigma0}{scalar. Standard deviation of the historical data.}

\item{N0}{scalar. Number of observations of the historical data.}

\item{number_mcmc}{scalar. Number of Monte Carlo simulations. Default is 10000.}

\item{method}{character. Analysis method. Default value "\code{fixed}" estimates
the posterior probability and holds it fixed. Alternative method "\code{mc}"
estimates the posterior probability for each Monte Carlo iteration.
See the the \code{bdpnormal} vignette \cr
\code{vignette("bdpnormal-vignette", package="bayesDP")} for more details.}
}
\value{
\code{probability_discount} returns an object of class "probability_discount".

An object of class \code{probability_discount} contains the following:
\describe{
 \item{\code{p_hat}}{
   scalar. The posterior probability of the comparison historical data weight. If
   \code{method="mc"}, a vector of posterior probabilities of length
   \code{number_mcmc} is returned.}
}
}
\description{
\code{probability_discount} can be used to estimate the posterior
  probability of the comparison between historical and current data in the
  context of a clinical trial with normal (mean) data.
  \code{probability_discount} is not used internally but is given for
  educational purposes.
}
\details{
This function is not used internally but is given for educational purposes.
  Given the inputs,  the output is the posterior probability of the comparison
  between current and historical data in the context of a clinical
  trial with normal (mean) data.
}
\examples{
probability_discount(mu  = 0,   sigma = 1, N  = 100,
                     mu0 = 0.1, sigma0 = 1, N0 = 100)

}
\references{
Haddad, T., Himes, A., Thompson, L., Irony, T., Nair, R. MDIC Computer
  Modeling and Simulation working group.(2017) Incorporation of stochastic
  engineering models as prior information in Bayesian medical device trials.
  \emph{Journal of Biopharmaceutical Statistics}, 1-15.
}
