% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getStatus.R
\name{getStatus}
\alias{getStatus}
\title{Summarize the Computational Status}
\usage{
getStatus(ids = NULL, reg = getDefaultRegistry())
}
\arguments{
\item{ids}{[\code{\link[base]{data.frame}} or \code{integer}]\cr
A \code{\link[base]{data.frame}} (or \code{\link[data.table]{data.table}})
with a column named \dQuote{job.id}.
Alternatively, you may also pass a vector of integerish job ids.
If not set, defaults to all jobs.
Invalid ids are ignored.}

\item{reg}{[\code{\link{Registry}}]\cr
Registry. If not explicitly passed, uses the default registry (see \code{\link{setDefaultRegistry}}).}
}
\value{
[\code{\link[data.table]{data.table}}] (with class \dQuote{Status} for printing).
}
\description{
This function gives an encompassing overview over the computational status on your system.
The status can be one or many of the following:
\itemize{
 \item \dQuote{defined}: Jobs which are defined via \code{\link{batchMap}} or \code{\link{addExperiments}}, but are not yet submitted.
 \item \dQuote{submitted}: Jobs which are submitted to the batch system via \code{\link{submitJobs}}, scheduled for execution.
 \item \dQuote{started}: Jobs which have been started.
 \item \dQuote{done}: Jobs which terminated successfully.
 \item \dQuote{error}: Jobs which terminated with an exception.
 \item \dQuote{running}: Jobs which are listed by the cluster functions to be running on the live system. Not supported for all cluster functions.
 \item \dQuote{queued}: Jobs which are listed by the cluster functions to be queued on the live system. Not supported for all cluster functions.
 \item \dQuote{system}: Jobs which are listed by the cluster functions to be queued or running. Not supported for all cluster functions.
 \item \dQuote{expired}: Jobs which have been submitted, but vanished from the live system. Note that this is determined heuristically and may include some false positives.
}
Here, a job which terminated successfully counts towards the jobs which are submitted, started and done.
To retrieve the corresponding job ids, see \code{\link{findJobs}}.
}
\examples{
\dontshow{ batchtools:::example_push_temp(1) }
tmp = makeRegistry(file.dir = NA, make.default = FALSE)
fun = function(i) if (i == 3) stop(i) else i
ids = batchMap(fun, i = 1:5, reg = tmp)
submitJobs(ids = 1:4, reg = tmp)
waitForJobs(reg = tmp)

tab = getStatus(reg = tmp)
print(tab)
str(tab)
}
\seealso{
\code{\link{findJobs}}<`3`>

Other debug: \code{\link{getErrorMessages}},
  \code{\link{grepLogs}}, \code{\link{killJobs}},
  \code{\link{resetJobs}}, \code{\link{showLog}},
  \code{\link{testJob}}
}
