% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterFunctions.R
\name{cfBrewTemplate}
\alias{cfBrewTemplate}
\title{Cluster Functions Helper to Write Job Description Files}
\usage{
cfBrewTemplate(reg, text, jc)
}
\arguments{
\item{reg}{[\code{\link{Registry}}]\cr
Registry. If not explicitly passed, uses the default registry (see \code{\link{setDefaultRegistry}}).}

\item{text}{[\code{character(1)}]\cr
String ready to be brewed. See \code{\link{cfReadBrewTemplate}} to read a template from the file system.}

\item{jc}{[\code{\link{JobCollection})}]\cr
Will be used as environment to brew the template file in. See \code{\link{JobCollection}} for a list of all
available variables.}
}
\value{
[\code{character(1)}]. File path to brewed template file.
}
\description{
This function is only intended for use in your own cluster functions implementation.

Calls brew silently on your template, any error will lead to an exception.
The file is stored at the same place as the corresponding job file in the \dQuote{jobs}-subdir
of your files directory.
}
\seealso{
Other ClusterFunctionsHelper: 
\code{\link{cfHandleUnknownSubmitError}()},
\code{\link{cfKillJob}()},
\code{\link{cfReadBrewTemplate}()},
\code{\link{makeClusterFunctions}()},
\code{\link{makeSubmitJobResult}()},
\code{\link{runOSCommand}()}
}
\concept{ClusterFunctionsHelper}
