% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotLikelihoods.R
\name{plotLikelihoods}
\alias{plotLikelihoods}
\title{Plot likelihoods}
\usage{
plotLikelihoods(
  mcmc_outputs,
  choice = "complete_likelihood",
  colour_by_chain = TRUE
)
}
\arguments{
\item{mcmc_outputs}{The output from ``runMCMCChains``.}

\item{choice}{The model fit score to use. Must be one of
``'observed_likelihood'``, ``'complete_likelihood'`` or ``'BIC'``. Defaults
to ``'complete_likelihood'``.}

\item{colour_by_chain}{Logical indcating if plots should be coloured by chain
or all the same colour. Defaults to ``TRUE``.}
}
\value{
A ggplot2 object. Line plot of likelihood across iteration.
}
\description{
Plots the model fit for multiple chains.
}
\examples{

# Data in a matrix format
X <- matrix(c(rnorm(100, 0, 1), rnorm(100, 3, 1)), ncol = 2, byrow = TRUE)

# Initial labelling
labels <- c(
  rep(1, 10),
  sample(c(1, 2), size = 40, replace = TRUE),
  rep(2, 10),
  sample(c(1, 2), size = 40, replace = TRUE)
)

fixed <- c(rep(1, 10), rep(0, 40), rep(1, 10), rep(0, 40))

# Batch
batch_vec <- sample(seq(1, 5), replace = TRUE, size = 100)

# Sampling parameters
R <- 1000
thin <- 50
n_chains <- 4

# MCMC samples
samples <- runMCMCChains(X, n_chains, R, thin, batch_vec, "MVN",
  initial_labels = labels, 
  fixed = fixed
)

p <- plotLikelihoods(samples)

}
