% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_nth_entry.R
\name{filter_nth_entry}
\alias{filter_nth_entry}
\title{Filter dataframe for nth entry}
\usage{
filter_nth_entry(data, ID_column, entry_column, n = 1, reverse_order = FALSE)
}
\arguments{
\item{data}{the data.frame to filter}

\item{ID_column}{character column identifying subjects}

\item{entry_column}{character column identifying order of entries.
That column can by of types Date, numeric, or any other type suitable for order()}

\item{n}{integer number of entry to keep after ordering}

\item{reverse_order}{logical when TRUE sorts entries last to first before filtering}
}
\value{
data.frame with <= 1 entry per subject
}
\description{
Filter a dataframe for the nth entry of each subject in it.
A typical use cases would be to filter a dataset for the first or last measurement of a subject.#'
}
\examples{
data <- data.frame(list(ID = rep(1:5, 3), encounter = rep(1:3, each=5), value = rep(4:6, each=5)))
filter_nth_entry(data, 'ID', 'encounter')
filter_nth_entry(data, 'ID', 'encounter', n = 2)
filter_nth_entry(data, 'ID', 'encounter', reverse_order = TRUE)


}
\author{
J. Peter Marquardt
}
