% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlb_divisions.R
\name{mlb_divisions}
\alias{mlb_divisions}
\title{\strong{MLB Divisions}}
\usage{
mlb_divisions(division_id = NULL, league_id = NULL, sport_id = NULL)
}
\arguments{
\item{division_id}{Return division(s) data for a specific division}

\item{league_id}{Return division(s) data for all divisions in a specific league}

\item{sport_id}{Return division(s) for all divisions in a specific sport.}
}
\value{
Returns a tibble with the following columns\tabular{ll}{
   col_name \tab types \cr
   division_id \tab integer \cr
   division_name \tab character \cr
   season \tab character \cr
   division_name_short \tab character \cr
   division_link \tab character \cr
   division_abbreviation \tab character \cr
   has_wildcard \tab logical \cr
   sort_order \tab integer \cr
   num_playoff_teams \tab integer \cr
   active \tab logical \cr
   league_id \tab integer \cr
   league_link \tab character \cr
   sport_id \tab integer \cr
   sport_link \tab character \cr
}
}
\description{
\strong{MLB Divisions}
}
\examples{
\donttest{
  try(mlb_divisions(sport_id = 1))
}
}
