% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bref_team_results.R
\name{bref_team_results}
\alias{bref_team_results}
\title{\strong{Scrape Team Results}}
\usage{
bref_team_results(Tm, year)
}
\arguments{
\item{Tm}{The abbreviation used by Baseball-Reference.com for the team whose results you want to scrape.}

\item{year}{Season for which you want to scrape the park factors.}
}
\value{
Returns a tibble of MLB team results and the following columns:\tabular{ll}{
   col_name \tab types \cr
   Gm \tab numeric \cr
   Date \tab character \cr
   Tm \tab character \cr
   H_A \tab character \cr
   Opp \tab character \cr
   Result \tab character \cr
   R \tab numeric \cr
   RA \tab numeric \cr
   Inn \tab character \cr
   Record \tab character \cr
   Rank \tab numeric \cr
   GB \tab character \cr
   Win \tab character \cr
   Loss \tab character \cr
   Save \tab character \cr
   Time \tab character \cr
   D/N \tab character \cr
   Attendance \tab numeric \cr
   cLI \tab numeric \cr
   Streak \tab numeric \cr
   Orig_Scheduled \tab character \cr
   Year \tab numeric \cr
}
}
\description{
This function allows you to scrape schedule and results for a major league team from Baseball-Reference.com
}
\examples{
\donttest{
  try(bref_team_results("NYM", 2015))
  try(bref_team_results(Tm="TBR", year=2008))
}
}
