% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlb_game_info.R
\name{mlb_game_info}
\alias{mlb_game_info}
\title{\strong{Retrieve additional game information for major and minor league games}}
\usage{
mlb_game_info(game_pk)
}
\arguments{
\item{game_pk}{The unique game_pk identifier for the game}
}
\value{
Returns a tibble that includes supplemental information, such as
weather, official scorer, attendance, etc., for the game_pk provided\tabular{ll}{
   col_name \tab types \cr
   game_date \tab character \cr
   game_pk \tab numeric \cr
   venue_name \tab character \cr
   venue_id \tab integer \cr
   temperature \tab character \cr
   other_weather \tab character \cr
   wind \tab character \cr
   attendance \tab character \cr
   start_time \tab character \cr
   elapsed_time \tab character \cr
   game_id \tab character \cr
   game_type \tab character \cr
   home_sport_code \tab character \cr
   official_scorer \tab character \cr
   date \tab character \cr
   status_ind \tab character \cr
   home_league_id \tab integer \cr
   gameday_sw \tab character \cr
}
}
\description{
\strong{Retrieve additional game information for major and minor league games}
}
\examples{
\donttest{
  try(mlb_game_info(game_pk = 566001))
}
}
