% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bref_daily_pitcher.R
\name{bref_daily_pitcher}
\alias{bref_daily_pitcher}
\title{\strong{Scrape Pitcher Performance Data Over a Custom Time Frame}}
\usage{
bref_daily_pitcher(t1, t2)
}
\arguments{
\item{t1}{First date data should be scraped from. Should take the form "YEAR-MONTH-DAY"}

\item{t2}{Last date data should be scraped from. Should take the form "YEAR-MONTH-DAY"}
}
\value{
Returns a tibble of pitcher performance with the following columns:\tabular{ll}{
   col_name \tab types \cr
   bbref_id \tab character \cr
   season \tab integer \cr
   Name \tab character \cr
   Age \tab numeric \cr
   Level \tab character \cr
   Team \tab character \cr
   G \tab numeric \cr
   GS \tab numeric \cr
   W \tab numeric \cr
   L \tab numeric \cr
   SV \tab numeric \cr
   IP \tab numeric \cr
   H \tab numeric \cr
   R \tab numeric \cr
   ER \tab numeric \cr
   uBB \tab numeric \cr
   BB \tab numeric \cr
   SO \tab numeric \cr
   HR \tab numeric \cr
   HBP \tab numeric \cr
   ERA \tab numeric \cr
   AB \tab numeric \cr
   X1B \tab numeric \cr
   X2B \tab numeric \cr
   X3B \tab numeric \cr
   IBB \tab numeric \cr
   GDP \tab numeric \cr
   SF \tab numeric \cr
   SB \tab numeric \cr
   CS \tab numeric \cr
   PO \tab numeric \cr
   BF \tab numeric \cr
   Pit \tab numeric \cr
   Str \tab numeric \cr
   StL \tab numeric \cr
   StS \tab numeric \cr
   GB.FB \tab numeric \cr
   LD \tab numeric \cr
   PU \tab numeric \cr
   WHIP \tab numeric \cr
   BAbip \tab numeric \cr
   SO9 \tab numeric \cr
   SO.W \tab numeric \cr
   SO_perc \tab numeric \cr
   uBB_perc \tab numeric \cr
   SO_uBB \tab numeric \cr
}
}
\description{
This function allows you to scrape basic pitcher statistics over a custom time frame. Data is sourced from Baseball-Reference.com.
}
\examples{
\donttest{
  try(bref_daily_pitcher("2015-05-10", "2015-06-20"))
}
}
