% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expfit.R
\name{expfit}
\alias{expfit}
\title{Estimate Exponential Growth rate from  Aoristic data}
\usage{
expfit(
  x,
  niter = 1e+05,
  nburnin = 50000,
  thin = 10,
  nchains = 4,
  rPrior = "dnorm(mean=0,sd=0.05)",
  rSampler = NULL,
  parallel = FALSE,
  seeds = 1:4
)
}
\arguments{
\item{x}{A ProbMat class object}

\item{niter}{Number of MCMC iterations. Default is 500,000.}

\item{nburnin}{Number of iterations discarded for burn-in. Default is 250,000.}

\item{thin}{Thinning interval}

\item{nchains}{Number of MCMC chains}

\item{rPrior}{A string defining prior for the growth parameter r. Default is 'dnorm(mean=0,sd=0.05)'.}

\item{rSampler}{A list containing settings for the MCMC sampler. Default is null and employs nimble's Default sampler (RW sampler).}

\item{parallel}{Logical specifying whether the chains should be run in parallel or not.}

\item{seeds}{Random seed for each chain. Default is 1:4.}
}
\value{
A \code{fittedExp} class object containing the original ProbMat class object, posterior of the growth rate, along with its Gelman Rubin statistic and effective sample sizes.
}
\description{
Fits an exponential growth model to \code{ProbMat} class objects.
}
\details{
The function fits a discrete bounded exponential growth model on the observed data using MCMC as implemented by the nimble package. The Bayesian model consists of a single growth rate parameter (r), and users can define suitable priors using character strings for the argument \code{rPrior} (for details on how this should be specified please consult the nimble manual). Please note that the function returns posterior of the growth rate normalised by the resolution defined in the \code{ProbMat} class object.  MCMC settings such as the choice the sampler, number of iterations, chains, etc can also be specified.
}
