% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bang.R
\docType{data}
\name{temp1}
\alias{temp1}
\title{Mid 21st Century Global Temperature Projection Data}
\format{A data frame with 270 rows and 4 columns.
  \itemize{
    \item{Column 1, index: }{anomaly of 2020-2049 mean relative to 1970-1999
      mean.}
    \item{Column 2, GCM: }{Abbreviated name of General Circulation Model.}
    \item{Column 3, RCP: }{Representative Concentration Pathway. One of
      rcp26, rcp45, rcp60, rcp85}
    \item{Column 4, run: }{Simulation run number.}
 }}
\source{
The raw data from which the indices are calculated are monthly
  CMIP5 scenario runs for global surface air temperature (tas)
  downloaded from the KNMI Climate Explorer (\url{https://climexp.knmi.nl/})
  on 4/3/2015.
}
\usage{
temp1
}
\description{
Indices of global temperature change from late 20th century (1970-1999)
to mid 21st century (2020-2049) based on data produced by the Fifth
Coupled Model Intercomparison Project (CMIP5).
}
\details{
The data frame \code{temp1} data frame has 270 rows and 4 columns.
Each row relates to a climate projection run from one of 38 different
General Circulation Models (GCMs) under a particular
Representative Concentration Pathway (RCP).
Use \code{table(temp1[, c("GCM", "RCP")])} to see the numbers of
runs under each RCP for each GCM.
See Van Vuuren et al (2011) for an overview of RCPs
and Northrop and Chandler (2014) for analyses of a similar
older dataset (CMIP3).
Column 1 contains the anomaly of the mean global temperature over
the time period 2020-2049 relative to the mean global temperature
over 1970-1999, i.e. the latter subtracted from the former.
Column 2 contains an abbreviation for the name of the climate modelling
research group and the GCM.
Column 3 contains the RCP in the format \code{rcpxx} where \code{xx}
is a radiative forcing level resulting from an anticipated future
greenhouse gas emissions.
Column 4 is the simulation run number.
}
\references{
Northrop, P.J. and R.E. Chandler (2014). Quantifying
  Sources of Uncertainty in Projections of Future Climate.
  \emph{Journal of Climate}, \strong{27}, 8793-8808.
  \url{https://doi.org/10.1175/JCLI-D-14-00265.1}

Van Vuuren, D. P., Edmonds, J., Kainuma, M., Riahi, K.
  Thomson, A., Hibbard, K., Hurtt, G. C., Kram, T., Krey, V.,
  Lamarque, J.-F. (2011). The representative concentration pathways:
  an overview. \emph{Climatic change}, \strong{109}, 5-31.
  \url{https://doi.org/10.1007/s10584-011-0148-z}
}
\keyword{datasets}
