% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_apc.R
\name{plot.apc}
\alias{plot.apc}
\title{Plot apc object}
\usage{
\method{plot}{apc}(x, quantiles = c(0.05, 0.5, 0.95), ...)
}
\arguments{
\item{x}{apc object}

\item{quantiles}{quantiles to plot. Default: \code{c(0.05,0.5,0.95)} is median and 90\% credible interval.}

\item{...}{Additional arguments will be ignored}
}
\value{
plot
}
\description{
Plot apc object
}
\details{
Plot of age, period and cohort effects from apc objects. If covariates have been used for period/cohort, a second plot with covariate, absolute effect and relative effect is created. Absolute effect is relative effect times covariate.
}
\examples{
\dontrun{
data(apc)
model <- bamp(cases, population, age="rw1", period="rw1", cohort="rw1", periods_per_agegroup = 5)
plot(model)
}
}
