% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occs2sparse.R
\name{occs2sparse}
\alias{occs2sparse}
\title{occs2sparse: Converts occurrence data into a sparse matrix object}
\usage{
occs2sparse(modelsparse, occs)
}
\arguments{
\item{modelsparse}{A setA object returned by the function
\code{\link[bamm]{model2sparse}}}

\item{occs}{A matrix or a data.frame containing two columns.
The first one is the longitude and the second is the latitude.}
}
\value{
A sparse vector of zeros (presences) and ones (absences).
}
\description{
occs2sparse: Converts occurrence data into a sparse matrix object
}
\details{
Rows of this column vector represent non NA pixels of the
niche model.
}
\examples{

model_path <- system.file("extdata/Lepus_californicus_cont.tif",
                          package = "bamm")
model <- raster::raster(model_path)

sparse_mod <- bamm::model2sparse(model,threshold=0.05)

occs_lep_cal <- data.frame(longitude = c(-115.10417,
                                         -104.90417),
                           latitude = c(29.61846,
                                        29.81846))

occs_sparse <- bamm::occs2sparse(modelsparse = sparse_mod,
                                occs = occs_lep_cal)

head(occs_sparse)
}
\author{
Luis Osorio-Olvera & Jorge Soberón
}
