% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeoff.R
\name{get_timeoff_requests}
\alias{get_timeoff_requests}
\title{Get Time Off Requests}
\usage{
get_timeoff_requests(
  start,
  end,
  id = NULL,
  action = c("view", "approve"),
  employee_id = NULL,
  type = NULL,
  status = c("approved", "denied", "superseded", "requested", "canceled"),
  api_version = "v1"
)
}
\arguments{
\item{start}{Character in format "YYYY-MM-DD". Only show time off that occurs on/after the specified start date.}

\item{end}{Character in format "YYYY-MM-DD". Only show time off that occurs on/before the specified end date.}

\item{id}{(optional) Integer - A particular request ID to limit the response to.}

\item{action}{(optional) - Limit to requests that the user has a particular level of access to. Legal values are: "view" or "approve".}

\item{employee_id}{(optional) Character - A particular employee ID to limit the response to.}

\item{type}{(optional) - A vector of time off types IDs to include limit the response to. Default is all types are included.}

\item{status}{(optional) - A vector of request status values to include. Legal values are "approved", "denied", "superseded", "requested", "canceled". Default is all status types.}

\item{api_version}{(optional) - Version of API to use to make request. Default is "v1".}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} object.
}
\description{
Get Time Off Requests
}
\examples{
\dontrun{
# find valid valid types
types <- get_timeoff_types()
type_ids <- types \%>\% tidyr::drop_na(id) \%>\%  dplyr::pull(id)

res <- get_timeoff_requests("2022-01-01", "2022-02-01", type = type_ids)

res2 <- get_timeoff_requests("2022-01-01", "2022-02-01", action = "approve",
                             status = c("approved", "denied"))

res3 <- get_timeoff_requests("2022-01-01", "2022-02-01", employee_id = "4")

}
}
\references{
\url{https://documentation.bamboohr.com/reference/time-off-1}
}
