% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbp.R
\name{sbp.fromABA}
\alias{sbp.fromABA}
\title{Build SBP Matrix of "Anti-Balances"}
\usage{
sbp.fromABA(x, alpha = NA)
}
\arguments{
\item{x}{A matrix with rows as samples (N) and columns as components (D).}

\item{alpha}{A double. Defines a hyper-parameter used
by the Box-Cox transformation to approximate log-ratio
variance in the presence of zeros. Skip with NA.}
}
\value{
An SBP matrix.
}
\description{
This function builds an SBP of "anti-balances" by clustering
 the difference of the log-ratio variance from the
 maximum log-ratio variance. Unlike principal balances,
 where the first balances explain the most variance,
 this function selects "anti-balances" so that the
 last balances explain the most variance.
}
\examples{
library(balance)
data(iris)
x <- iris[,1:4]
sbp.fromABA(x)

}
\author{
Thom Quinn
}
