% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate-nplcm.R
\name{simulate_latent}
\alias{simulate_latent}
\title{Simulate Latent Status:}
\usage{
simulate_latent(set_parameter)
}
\arguments{
\item{set_parameter}{True model parameters in an npLCM specification:
\describe{
\item{\code{cause_list}}{ a vector of disease class names among cases (since
the causes could be multi-agent (e.g., multiple pathogens may cause an individual case's
pneumonia), so its length could be longer than the total number of unique
causative agents)}
\item{\code{etiology}}{ a vector of proportions that sum to 100 percent}
\item{\code{pathogen_BrS}}{ a vector of putative causative agents' names measured in bronze-standard (BrS) data.
This function simulates only one slice defined by \verb{specimen``test``pathogen}}
\item{\code{pathogen_SS}}{ a vector of pathogen names measured in silver-standard (SS) data.}
\item{\code{meas_nm}}{ a list of \verb{specimen``test} names e.g., \code{list(MBS = c("NPPCR"),MSS="BCX")}
for nasopharyngeal (NP) specimen tested by polymerase chain reaction (PCR) - \code{NPPCR} and
blood (B) tested by culture (Cx) - \code{BCX}}
\item{\code{Lambda}}{ controls' subclass weights \eqn{\nu_1, \nu_2, \ldots, \nu_K}
a vector of \code{K} probabilities that sum to 1.}
\item{\code{Eta}}{    a matrix of dimension \code{length(cause_list)} by \code{K};
each row represents a disease class (among cases); the values in that row
are subclass weights \eqn{\eta_1, \eta_2, \ldots, \eta_K} for that disease class,
so needs to sum to one. In Wu et al. 2016 (JRSS-C), the subclass weights are the same across disease
classes across rows. But when simulating data, one can specify rows with distinct
subclass weights - it is a matter whether we can recover these parameters (possible when
some cases' true disease classes are observed)}
\item{\code{PsiBS/PsiSS}}{ False positive rates for Bronze-Standard data and
for Silver-Standard data. For example, the rows of \code{PsiBS} correspond to the dimension of the particular
slice of BrS measures, e.g., \code{10} for 10 causative agents measured by NPPCR; the
columns correspond to \code{K} subclasses; generically, the dimension is \code{J} by \code{K}
\code{PsiSS} is supposed to be a vector of all zeros (perfect specificity in silver-standard measures).}
\item{\code{ThetaBS/ThetaSS}}{  True positive rates \eqn{\Theta} for Bronze-Standard data and
for Silver-Standard data. Dimension is \code{J} by \code{K} (can contain \code{NA} if the total number of
causative agents measured by BrS or SS exceeds the measured causative agents in SS. For example,
in PERCH study, nasopharyngeal polymerase chain reaction (NPPCR; bronze-standard) may target 30 distinct pathogens, but blood culture (BCX; silver-standard) may only target a subset of the 30,
so we have to specify \code{NA} in \code{ThetaSS}for those pathogens not targeted by BCX).}
\item{\code{Nu}}{ the number of control subjects}
\item{\code{Nd}}{ the number of case subjects}
}}
}
\value{
a list of latent status samples for use in simulating measurements. It
also includes a template to look up measurement parameters for each disease class.
}
\description{
Simulate Latent Status:
}
\seealso{
Other internal simulation functions: 
\code{\link{simulate_brs}()},
\code{\link{simulate_ss}()}
}
\concept{internal simulation functions}
