% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-panels.R
\name{plot_pie_panel}
\alias{plot_pie_panel}
\title{Plot etiology (pie) panel}
\usage{
plot_pie_panel(
  model_options,
  res_nplcm,
  bugs.dat,
  bg_color,
  select_latent = NULL,
  exact = TRUE,
  top_pie = 1,
  label_size = 1,
  ref_eti = NULL,
  is_plot = TRUE
)
}
\arguments{
\item{model_options}{See \code{\link[=nplcm]{nplcm()}}}

\item{res_nplcm}{See \code{\link[=nplcm_read_folder]{nplcm_read_folder()}}}

\item{bugs.dat}{Data input for the model fitting.}

\item{bg_color}{A list with names "BrS", "SS", "pie" to specify background colors}

\item{select_latent}{a vector of character strings representing latent status. It is used for
just plotting a subset of latent status. For example, you can specify \code{select_latent = "HINF"}}

\item{exact}{Default is \code{TRUE} to use \code{select_latent} as exact names of causes. If you want to
specify a name and plot all single or combo causes with that name, specify it to be \code{FALSE}.
to plot all latent status information relevant to \code{"HINF"}.}

\item{top_pie}{Numerical value to specify the rightmost limit
on the horizontal axis for the pie panel.}

\item{label_size}{the size of latent status labels on the right margin}

\item{ref_eti}{reference quantiles and means; a list: pEti_ref_q, pEti_ref_mean_ord}

\item{is_plot}{default to \code{TRUE} for plotting only; set to \code{FALSE} if to get summary.}
}
\value{
plotting function.
}
\description{
Plot etiology (pie) panel
}
\seealso{
Other visualization functions: 
\code{\link{plot.nplcm}()},
\code{\link{plot_BrS_panel}()},
\code{\link{plot_SS_panel}()},
\code{\link{plot_check_common_pattern}()},
\code{\link{plot_check_pairwise_SLORD}()},
\code{\link{plot_etiology_regression}()},
\code{\link{plot_etiology_strat}()},
\code{\link{plot_panels}()},
\code{\link{plot_subwt_regression}()}
}
\concept{visualization functions}
