% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nplcm.R
\name{nplcm_fit_Reg_discrete_predictor_NoNest}
\alias{nplcm_fit_Reg_discrete_predictor_NoNest}
\title{Fit nested partially-latent class model with regression (low-level)}
\usage{
nplcm_fit_Reg_discrete_predictor_NoNest(
  data_nplcm,
  model_options,
  mcmc_options
)
}
\arguments{
\item{data_nplcm}{Cases are on top of controls in the rows of diagnostic
test results and the covariate matrix. This is assumed by \code{baker} to automatically
write model files (\code{.bug}).
\itemize{
\item  \code{Mobs} A list of measurements of distinct qualities (Bronze-, Silver, and Gold-Standard:
\code{MBS},\code{MSS},\code{MGS}). The elements of the list
should include \code{MBS}, \code{MSS}, and \code{MGS}. If any of the component
is not available, please specify it as, e.g., \code{MGS=NULL}
(effectively deleting \code{MGS} from \code{Mobs}).
\itemize{
\item \code{MBS} a list of data frame of bronze-standard (BrS) measurements.
Rows are subjects, columns are causative agents (e.g., pathogen species).
We use \code{list} here to accommodate the possibility of multiple sets of BrS data.
They have imperfect sensitivity/specificity (e.g. nasopharyngeal polymerase chain
reaction - NPPCR).
\item \code{MSS} a list of data frame of silver-standard (SS) measurements.
Rows are subjects, columns are causative agents measured in specimen (e.g. blood culture).
These measurements have perfect specificity but imperfect sensitivity.
\item \code{MGS} a list of data frame of gold-standard (GS) measurements.
Rows are subject, columns are measured causative agents
These measurements have perfect sensitivity and specificity.
}

\item \code{Y} Vector of disease status: \code{1} for case, \code{0} for control.
\item \code{X} Covariate matrix. A subset of columns are primary covariates in cause-specific-
case-fraction (CSCF) functions and hence must be available for cases, and another subset
are covariates that are available in the cases and the controls.
The two sets of covariates may be identical, overlapping or completely different.
In general, this is not the design matrix for regression models,
because for enrollment date in a study which may have non-linear effect,
basis expansion is often needed for approximation.
}}

\item{model_options}{A list of model options: likelihood and prior.
\describe{
\item{\code{use_measurements}}{
A vector of characters strings; can be one or more from \code{"BrS"}, \code{"SS"}, \code{"GS"}.
}
\item{\code{likelihood}}{
\itemize{
\item{cause_list} The vector of causes (NB: specify);
\item{k_subclass} The number of nested subclasses in each
disease class (one of case classes or the control class; the same \code{k_subclass}
is assumed for each class) and each slice of BrS measurements.
\code{1} for conditional independence; larger than \code{1} for conditional dependence.
It is only available for BrS measurements. It is a vector of length equal to
the number of slices of BrS measurements;
\item{Eti_formula} Formula for etiology regressions. You can use
\code{\link[=s_date_Eti]{s_date_Eti()}} to specify the design matrix for \code{R} format enrollment date;
it will produce natural cubic spline basis. Specify \code{~ 1} if no regression is intended.
\item{FPR_formula}formula for false positive rates (FPR) regressions; see \code{\link[=formula]{formula()}}.
You can use \code{\link[=s_date_FPR]{s_date_FPR()}} to specify part of the design matrix for \code{R}
format enrollment date; it will produce penalized-spline basis (based on B-splines).
Specify \code{~ 1} if no regression is intended. (NB: If \code{effect="fixed"}, \code{\link[=dm_Rdate_FPR]{dm_Rdate_FPR()}}
will just specify a design matrix with appropriately standardized dates.)
}
}

\item{\code{prior}}{
\itemize{
\item{Eti_prior}Description of etiology prior (e.g., \code{overall_uniform} -
all hyperparameters are \code{1}; or \verb{0_1} - all hyperparameters are \code{0.1});
\item{TPR_prior}Description of priors for the measurements
(e.g., informative vs non-informative). Its length should be the same with \code{M_use}.
(NB: not sure what M use is...)
}
}
}}

\item{mcmc_options}{A list of Markov chain Monte Carlo (MCMC) options.
\itemize{
\item \code{debugstatus} Logical - whether to pause WinBUGS after it finishes
model fitting; (NB: is this obsolete? Test.)
\item \code{n.chains} Number of MCMC chains;
\item \code{n.burnin} Number of burn-in iterations;
\item \code{n.thin} To keep every other \code{n.thin} samples after burn-in period;
\item \code{individual.pred} \code{TRUE} to perform individual prediction (\code{Icat}
variables in the \code{.bug} file); \code{FALSE} otherwise;
\item \code{ppd} \code{TRUE} to simulate new data (\code{XXX.new}
variables in the \code{.bug} file) from the posterior predictive distribution (ppd);
\code{FALSE} otherwise;
\item \code{get.pEti} \code{TRUE} for getting posterior samples of individual etiologic fractions;
\code{FALSE} otherwise. For non-regression, or regression models with all discrete predictors,
by default this is \code{TRUE}, so no need to specify this entry. It is only relevant for regression models
with non-discrete covariates. Because individuals have distinct CSCFs at their specific covariate values,
it's easier to just store the posterior samples of the regression coefficients and reconstruct the pies afterwards,
rather than storing them through \code{JAGS}.
\item \code{result.folder} Path to folder storing the results;
\item \code{bugsmodel.dir} Path to \code{.bug} model files;
\item \code{jags.dir} Path to where JAGS is installed; if \code{NULL}, this will be set
to \code{jags.dir=""}.
}}
}
\value{
BUGS fit results.
}
\description{
Fit nested partially-latent class model with regression (low-level)
}
\details{
This function prepares data, specifies hyperparameters in priors
(true positive rates and etiology fractions), initializes the posterior
sampling chain, writes the model file (for JAGS or WinBUGS with slight
differences in syntax), and fits the model. Features:
\itemize{
\item regression;
\item no nested subclasses, i.e. conditional independence of
multivariate measurements given disease class and covariates;
\item multiple BrS + multiple SS.
}
If running JAGS on windows, please go to control panel to add the directory to
jags into ENVIRONMENTAL VARIABLE!
}
\seealso{
\link{write_model_NoReg} for automatically generate \code{.bug} model
file; This present function store it in location: \code{mcmc_options$bugsmodel.dir}.

Other model fitting functions: 
\code{\link{nplcm_fit_NoReg}()},
\code{\link{nplcm_fit_Reg_Nest}()},
\code{\link{nplcm_fit_Reg_NoNest}()}
}
\concept{model fitting functions}
