% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/out.mcmclist.R
\name{diagnostic.mcmc}
\alias{diagnostic.mcmc}
\title{Diagnostic of \emph{mcmc.2pnob} or \emph{mcmc.3pnob} object}
\usage{
diagnostic.mcmc(mcmclist, ...)
}
\arguments{
\item{mcmclist}{A \emph{mcmc.2pnob} or \emph{mcmc.3pnob} class object.}

\item{...}{Further arguments.}
}
\value{
Data frame with the summary. It including calculus of Rhat, posterior mean,
posterior standard deviation and posterior quartiles.
}
\description{
This function give the summary for all MCMC chains. It including calculus of
Rhat, posterior mean, posterior standard deviation and posterior quartiles.
}
\examples{
# data for model
data("MathTest")

# Only for the first 500 examinees of the data MathTest
# Two-Parameter Normal Ogive Model
model2 <- mcmc.2pnob(MathTest[1:500,], iter = 100, burning = 0)
diagnostic.mcmc(model2)

\donttest{
# For all examinees of the data
# Three-Parameter Normal Ogive Model
model3 <- mcmc.3pnob(MathTest, iter = 3500, burning = 500)
diagnostic.mcmc(model3)
}

## End(Not run)


}
\references{
Gelman, A., Carlin, J. B., Stern, H. S. & Rubin, B. (2004).
Bayesian Data Analysis.New York: Chapman & Hall/CRC.
}
\seealso{
\code{\link{mcmc.2pnob}}, \code{\link{mcmc.3pnob}} and
\code{\link{continue.mcmc.bairt}}.
}
\author{
Javier Martínez
}
