% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loocv.R
\name{loo_compare}
\alias{loo_compare}
\title{Compare LOO CV models}
\usage{
loo_compare(...)
}
\arguments{
\item{...}{A series of \code{baggr_cv} objects passed as arguments, with a minimum of 2
arguments required for comparison. \code{baggr_cv} objects can be created via the
\link{loocv} function. In instances where more than 2 arguments are passed, the
first model will be compared sequentially to all other provided models.
Arguments can be passed with names (see example below).}
}
\value{
Returns a series of comparisons in order of the arguments provided as Model 1 - Model N for
N loocv objects provided. Model 1 corresponds to the first object passed and
Model N corresponds to the Nth object passed.
}
\description{
Given multiple \link{loocv} outputs, calculate differences in their expected log
predictive density.
}
\examples{
\dontrun{
# 2 models with more/less informative priors -- this will take a while to run
cv_1 <- loocv(schools, model = "rubin", pooling = "partial")
cv_2 <- loocv(schools, model = "rubin", pooling = "partial",
              prior_hypermean = normal(0, 5), prior_hypersd = cauchy(0,2.5))
loo_compare("Default prior"=cv_1,"Alternative prior"=cv_2)
}
}
\seealso{
\link{loocv} for fitting LOO CV objects and explanation of the procedure;
loo package by Vehtari et al (available on CRAN) for a more comprehensive approach
}
