% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_ma.R
\name{prepare_ma}
\alias{prepare_ma}
\title{Convert from individual to summary data in meta-analyses}
\usage{
prepare_ma(
  data,
  effect = c("mean", "logOR", "logRR"),
  rare_event_correction = 0.25,
  log = FALSE,
  cfb = FALSE,
  summarise = TRUE,
  treatment = "treatment",
  baseline = NULL,
  group = "group",
  outcome = "outcome"
)
}
\arguments{
\item{data}{\strong{either} a data.frame of individual-level observations
with columns for outcome (numeric), treatment (values 0 and 1) and
group (numeric, character or factor); \strong{or}, a data frame with binary data
(must have columns \code{a}, \code{c}, \code{b}/\code{n1}, \code{d}/\code{n2}).}

\item{effect}{what effect to calculate? a \code{mean} (and SE) of outcome in groups or
(for binary data) \code{logOR} (odds ratio), \code{logRR} (risk ratio);}

\item{rare_event_correction}{If effect is \code{logOR} or \code{logRR}, this correction
is used when working with
binary data only. The value of correction is added to all arms
in trials where some arms had 0 events.
Using corrections may bias results but is the only alternative to
avoid infinite values.}

\item{log}{logical; log-transform the outcome variable?}

\item{cfb}{logical; calculate change from baseline? If yes, the outcome
variable is taken as a difference between values in \code{outcome} and
\code{baseline} columns}

\item{summarise}{logical; \code{TRUE} by default, but you can disable it to obtain
converted (e.g. logged) data with columns renamed}

\item{treatment}{name of column with treatment variable}

\item{baseline}{name of column with baseline variable}

\item{group}{name of the column with grouping variable}

\item{outcome}{name of column with outcome variable}
}
\value{
\itemize{
\item If you \code{summarise}: a data.frame with columns for \code{group}, \code{tau} and \code{se.tau}
(for \code{effect = "mean"}, also baseline means; for \code{"logRR"} or \code{"logOR"} also
\code{a}, \code{b}, \code{c}, \code{d}, which correspond to typical contingency table notation, that is:
\code{a} = events in exposed; \code{b} = no events in exposed, \code{c} = events in unexposed,
\code{d} = no events in unexposed).
\item If you do not summarise data, individual level data will be returned, but
some columns may be renamed or transformed (see the arguments above).
}
}
\description{
Allows for one-way conversion from full to summary data or for calculation of effects for binary data.
Input must be pre-formatted appropriately.
}
\details{
The conversions done by this function are not typically needed and may happen automatically
when \code{data} is given to \link{baggr}. However, this function can be used to explicitly
convert from full to reduced (summarised) data without analysing it in any model.
It can be useful for examining your data and generating summary tables.

If multiple operations are performed, they are taken in this order:
\enumerate{
\item conversion to log scale,
\item calculating change from baseline,
\item summarising data (using appropriate \code{effect})
}
}
\seealso{
\link{convert_inputs} for how any type of data is (internally) converted into
a list of Stan inputs;
}
\author{
Witold Wiecek
}
