% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdsm.R
\name{fdsm}
\alias{fdsm}
\title{The fixed degree sequence model (fdsm) for backbone probabilities}
\usage{
fdsm(B, trials = 1000, dyad = NULL, progress = FALSE, ...)
}
\arguments{
\item{B}{graph: An unweighted bipartite graph object of class matrix, sparse matrix, igraph, edgelist, or network object.
Any rows and columns of the associated bipartite matrix that contain only zeros are automatically removed before computations.}

\item{trials}{numeric: If trials > 1, this represents the number of bipartite graphs generated from the sampled distribution. If 0<trials<1, the number of graphs generated will be \eqn{(R^2-R)/trials + 1} where `R` is the number of rows.
This is the minimum number of trials required to achieve a 'trials' familywise error rate when extracting the backbone using \link{backbone.extract}}

\item{dyad}{vector length 2: two row entries i,j. Saves each value of the i-th row and j-th column in each projected B* matrix. This is useful for visualizing an example of the empirical null edge weight distribution generated by the model. These correspond to the row and column indices of a cell in the projected matrix, and can be written as their string row names or as numeric values.}

\item{progress}{Boolean: If \link[utils]{txtProgressBar} should be used to measure progress}

\item{...}{optional arguments}
}
\value{
backbone, a list(positive, negative, dyad_values, summary). Here
    `positive` is a matrix of proportion of times each entry of the projected matrix B is above the corresponding entry in the generated projection,
    `negative` is a matrix of proportion of times each entry of the projected matrix B is below the corresponding entry in the generated projection,
    `dyad_values` is a list of edge weight for i,j in each generated projection, and
    `summary` is a data frame summary of the inputted matrix and the model used including: model name, number of rows, skew of row sums, number of columns, skew of column sums, and running time.
}
\description{
`fdsm` computes the proportion of generated edges above
    or below the observed value using the fixed degree sequence model.
    Once computed, use \code{\link{backbone.extract}} to
    return the backbone matrix for a given alpha value.
}
\details{
During each iteration, fdsm computes a new B* matrix using the \link{curveball} algorithm. This is a random bipartite matrix with the same row and column sums as the original matrix B.
    If a value is supplied for the dyad parameter, when the B* matrix is projected (multiplied by its transpose), the value in the corresponding row and column will be saved.
    This allows the user to see the distribution of the edge weights for desired row and column.

The "backbone" S3 class object returned is composed of two matrices, a summary dataframe and (if specified) a 'dyad_values' vector.
}
\examples{
fdsm_props <- fdsm(davis, trials = 100, dyad=c(3,6))
}
\references{
fixed degree sequence model: {Zweig, Katharina Anna, and Michael Kaufmann. 2011. “A Systematic Approach to the One-Mode Projection of Bipartite Graphs.” Social Network Analysis and Mining 1 (3): 187–218. \doi{10.1007/s13278-011-0021-0}}

curveball algorithm: {Strona, Giovanni, Domenico Nappo, Francesco Boccacci, Simone Fattorini, and Jesus San-Miguel-Ayanz. 2014. “A Fast and Unbiased Procedure to Randomize Ecological Binary Matrices with Fixed Row and Column Totals.” Nature Communications 5 (June). Nature Publishing Group: 4114. \doi{10.1038/ncomms5114}}
}
