% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runOptLocal.R
\name{runOptLocal}
\alias{runOptLocal}
\title{runOptLocal}
\usage{
runOptLocal(
  X,
  rkiwerte = babsim.hospital::rkidata,
  icuwerte = babsim.hospital::icudata,
  region = 5374,
  TrainFieldStartDate = NULL,
  TrainSimStartDate = NULL,
  verbosity = 0,
  seed = 123,
  funEvals = 35,
  simrepeats = 2,
  parallel = FALSE,
  percCores = NULL,
  icu = TRUE,
  icuWeights = 1,
  resourceNames = c("intensiveBed", "intensiveBedVentilation"),
  resourceEval = c("intensiveBed", "intensiveBedVentilation"),
  spotEvalsParallel = FALSE
)
}
\arguments{
\item{X}{matrix of parameters. Each row should contain one parameterset to which a local optimization is applied}

\item{rkiwerte}{RKI Daten}

\item{icuwerte}{ICU Daten}

\item{region}{Landkreis Id, e.g., \code{5374} fuer OBK, \code{5315} fuer Koeln,
\code{0} fuer Deutschland,
oder Bundesland ID, e.g., \code{5} fuer NRW.}

\item{TrainFieldStartDate}{Start (Tag), e.g., \code{"2020-06-01"}}

\item{TrainSimStartDate}{Start (Tag), e.g., \code{"2020-05-01"}}

\item{verbosity}{verbosity (int). Default: \code{0}}

\item{seed}{Seed}

\item{funEvals}{Auswertungen fuer SPOT (Simulationen,
die fuer einen SPOT Lauf zur Verfuegung stehen)}

\item{simrepeats}{Sim Wdhlg}

\item{parallel}{logical}

\item{percCores}{percentage}

\item{icu}{ICU Daten}

\item{icuWeights}{Gewichtung der ICU Betten}

\item{resourceNames}{Name der Ressourcen}

\item{resourceEval}{Name der zu evaluierenden Ressourcen}

\item{spotEvalsParallel}{Should the spot repeats be evaluated in parallel?}
}
\description{
Run a local optimization on a set of parameters
}
