% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggVisualizeRkiExtendedDataCalculation.R
\name{ggVisualizeRkiExtendedDataCalculation}
\alias{ggVisualizeRkiExtendedDataCalculation}
\title{Data precalculation for ggVisualizeRkiExtended}
\usage{
ggVisualizeRkiExtendedDataCalculation(
  data = extendRki(),
  region = 5374,
  StartDate = "2020-10-01",
  simplify = TRUE
)
}
\arguments{
\item{data}{rki data as preprocessed by \code{\link{extendRki}}}

\item{region}{Landkreis Id, e.g., \code{5374} oder Bundesland ID, e.g., \code{5}.}

\item{StartDate}{Start (Tag), e.g., \code{'2020-05-01'}}

\item{simplify}{logical. Simplify presentation, Default: TRUE.}
}
\description{
Data for ggplot RKI data as result from \code{\link{extendRki}}
}
\examples{
data <- getRkiData(babsim.hospital::rkidata[1:10000, ])
# data size sufficient?: 
if (dim(data)[1]> 1e6){
p <- ggVisualizeRkiExtended(
  data = extendRki(data),
  region = 5374, StartDate = "2020-10-01"
)
}
}
\seealso{
\code{\link{rkidata}}
}
