% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synth_sounds.R
\name{synth_sounds}
\alias{synth_sounds}
\title{Create synthetic sounds}
\usage{
synth_sounds(
  replicates = 1,
  frequencies,
  durations,
  nharmonics = 1,
  fm = FALSE,
  am = FALSE,
  am.amps = rep(c(1:4, 3:2), length.out = 11),
  mar = 0.05,
  seed = NULL,
  sig2 = 0.3,
  shuffle = FALSE,
  hrm.freqs = c(1/2, 1/3, 2/3, 1/4, 3/4, 1/5, 1/6, 1/7, 1/8, 1/9, 1/10),
  sampling.rate = 44.1,
  pb = TRUE
)
}
\arguments{
\item{replicates}{Numeric vector of length 1 indicating the number of replicates for each treatment combination. Default is 1. Useful for measuring variation in transmission parameters.}

\item{frequencies}{Numeric vector with the different frequencies (in seconds) to synthesize. A Brownian bridge motion stochastic process (\code{diff.fun == "BB"}) is used to simulate frequency modulation (see \code{\link[warbleR]{simulate_songs}}).}

\item{durations}{Numeric vector with the different durations (in seconds) to synthesize.}

\item{nharmonics}{Numeric vector of length 1 specifying the number of harmonics to simulate. 1 indicates that only the fundamental
frequency harmonic will be simulated.}

\item{fm}{Logical to control if both frequency modulated sounds and pure tones (i.e. non-modulated sounds) are synthesize. If \code{FALSE} (default) only pure tones are synthesized.}

\item{am}{Logical to control if both amplitude modulated sounds and non-modulated sounds are synthesize. If \code{FALSE} (default) only non-modulated sounds are synthesized.}

\item{am.amps}{Numeric vector with the relative amplitude for each time step to simulate amplitude modulation (only applied to the fundamental frequency). The default value (\code{rep(c(1:4, 3:2), length.out = 11)}) has 2 amplitude peaks (although only applied if 'am = TRUE')}

\item{mar}{Numeric vector with the duration of margins of silence around sounds in seconds. Default is \code{0.05}.}

\item{seed}{Numeric vector of length 1. This allows users to get the same results in different runs (using \code{\link[base:Random]{se.seed}} internally). Default is \code{NULL}.}

\item{sig2}{Numeric vector of length 1 defining the sigma value of the brownian motion model (used for simulating frequency modulation). Default is 0.3.}

\item{shuffle}{Logical to control if the position of sounds is randomized. Having all sounds from the same treatment in a sequence can be problematic if an environmental noise masks them. Hence 'shuffle' is useful to avoid having sounds from the same treatment next to each other. Default is \code{FALSE}.}

\item{hrm.freqs}{Numeric vector with the frequencies of the harmonics relative to the fundamental frequency. The default values are c(1/2, 1/3, 2/3, 1/4, 3/4, 1/5, 1/6, 1/7, 1/8, 1/9, 1/10).}

\item{sampling.rate}{Numeric vector of length 1. Sets the sampling frequency of the wave object (in kHz). Default is 44.1.}

\item{pb}{Logical argument to control if progress bar is shown. Default is \code{TRUE}.  Can be set globally for the current R session via the "pb" option (see \code{\link[base]{options}}).}
}
\value{
An extended selection table, which can be input into \code{\link{master_sound_file}} to create the .wav file. The table contains columns for each of the varying features a 'treatment' column (useful to tell the acoustic features of each sound) and a 'replicate' column indicating the replicates for each 'treatment'.
}
\description{
\code{synth_sounds} create synthetic sounds
}
\details{
This function creates synthetic sounds that can be used for playback experiments to understand the link between signal structure and its transmission properties. The function can add variation in signal structure in 5 features:
\itemize{
   \item \code{frequency}: continuous, argument 'frequencies'.
   \item \code{duration}: continuous, argument 'durations'.
   \item \code{harmonic structure}: binary (harmonics vs no-harmonics), arguments 'nharmonics' and 'hrm.freqs'.
   \item \code{frequency modulation}: variation in fundamental frequency across time. Binary (modulated vs non-modulated), arguments 'fm' and 'sig2'.
   \item \code{amplitude modulation}: variation in amplitude across time. Binary (modulated vs non-modulated), arguments 'am' and 'am.amps'.
}
Sound for all possible combinations of the selected structure dimensions will be synthesized. The output is an extended selection table, which can be input into \code{\link{master_sound_file}} to create the .wav file. The functions uses \code{\link[warbleR]{simulate_songs}} internally for synthesizing individual sounds. A Brownian bridge motion stochastic process (\code{diff.fun == "BB"}) is used to simulate frequency modulation. The output table contains columns for each of the varying features and a 'treatment' column (useful to tell sound from the same combination of features when using replicates).
}
\examples{
\dontrun{

synthetic_est <- synth_sounds(
  mar = 0.01,
  frequencies = c(1, 2, 3, 5),
  durations = 0.1,
  fm = TRUE,
  am = TRUE,
  nharmonics = 4,
  shuffle = TRUE,
  replicates = 3
)
}

}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\seealso{
\code{\link[warbleR]{simulate_songs}} from the package warbleR.

Other prepare acoustic data: 
\code{\link{master_sound_file}()}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
\concept{prepare acoustic data}
