% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_route_directions.R
\name{get_routes}
\alias{get_routes}
\title{Extract and Combine Routes from an 'Azure Maps' Response}
\usage{
get_routes(resp)
}
\arguments{
\item{resp}{An \code{httr2_response} object, typically from a successful call to
\code{req_route_directions}.}
}
\value{
An \code{sf} object containing the combined main and alternative routes.
If the request was not successful (status code is not 200), the function
will stop with an error.
}
\description{
This function takes a successful response object from the 'Azure Maps' API,
extracts the main route and any alternative routes, and combines them into a
single \code{sf} object.
}
\examples{
\dontrun{
# Assuming 'response' is a successful response from req_route_directions
all_routes_sf <- get_routes(response)
plot(sf::st_geometry(all_routes_sf))
}
}
