% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_blob.R
\name{generate_blob}
\alias{generate_blob}
\title{Generate Random Blob}
\usage{
generate_blob(bytes = 1, ...)
}
\arguments{
\item{bytes}{An integer specifying a number of bytes between 1 and 1024.}

\item{\dots}{Additional arguments passed to \code{\link{kmsHTTP}}.}
}
\value{
A base64-encoded character string.
}
\description{
Generate a random byte string
}
\details{
\code{create_kms_alias} creates an alias for KMS key, which can be used in place of the KeyId or ARN. A given key can have multiple aliases. \code{delete_kms_alias} deletes an named alias. \code{update_kms_alias} reassigns an alias to a new key.
}
\examples{
\dontrun{
  b <- generate_blob()
  if (require("base64enc")) {
     base64enc::base64decode(b)
  }
}
}
\seealso{
\code{\link{create_kms_key}}, \code{\link{encrypt}}
}
