% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_register_image}
\alias{ec2_register_image}
\title{Register Image}
\usage{
ec2_register_image(
  Name,
  ImageLocation = NULL,
  Architecture = NULL,
  BlockDeviceMapping = NULL,
  Description = NULL,
  DryRun = NULL,
  EnaSupport = NULL,
  KernelId = NULL,
  BillingProduct = NULL,
  RamdiskId = NULL,
  RootDeviceName = NULL,
  SriovNetSupport = NULL,
  VirtualizationType = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{Name}{Character.   A name for your AMI.}

\item{ImageLocation}{Character. The full path to your AMI manifest in Amazon S3 storage.[optional]}

\item{Architecture}{Character.   The architecture of the AMI.[optional]}

\item{BlockDeviceMapping}{List.   The block device mapping entries.[optional]}

\item{Description}{Character. A description for your AMI.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{EnaSupport}{Logical.   Set to \code{true} to enable enhanced networking with ENA for the AMI and any instances that you launch...[optional]}

\item{KernelId}{Character. The ID of the kernel.[optional]}

\item{BillingProduct}{List. The billing product codes.[optional]}

\item{RamdiskId}{Character. The ID of the RAM disk.[optional]}

\item{RootDeviceName}{Character. The device name of the root device volume (for example, \verb{/dev/sda1}).[optional]}

\item{SriovNetSupport}{Character.   Set to \code{simple} to enable enhanced networking with the Intel 82599 Virtual Function interface for...[optional]}

\item{VirtualizationType}{Character.   The type of virtualization (\code{hvm} \| \code{paravirtual}).  Default: \code{paravirtual}  [optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Register Image
}
\section{Name}{


A name for your AMI.

Constraints: 3-128 alphanumeric characters, parentheses (()), square
brackets ([]), spaces ( ), periods (.), slashes (/), dashes (-),
single quotes (\'), at-signs (@), or underscores(_)
}

\section{ImageLocation}{

The full path to your AMI manifest in Amazon S3
storage. The specified bucket must have the \code{aws-exec-read} canned
access control list (ACL) to ensure that it can be accessed by Amazon
EC2. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl}{Canned ACLs}
in the \emph{Amazon S3 Service Developer Guide}.
}

\section{Architecture}{


The architecture of the AMI.

Default: For Amazon EBS-backed AMIs, \code{i386}. For instance store-backed
AMIs, the architecture specified in the manifest file.
}

\section{BlockDeviceMapping}{


The block device mapping entries.

If you specify an EBS volume using the ID of an EBS snapshot, you can\'t
specify the encryption state of the volume.

If you create an AMI on an Outpost, then all backing snapshots must be
on the same Outpost or in the Region of that Outpost. AMIs on an Outpost
that include local snapshots can be used to launch instances on the same
Outpost only. For more information, \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami}{Amazon EBS local snapshots on Outposts}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}

\section{Description}{

A description for your
AMI.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{EnaSupport}{


Set to \code{true} to enable enhanced networking with ENA for the AMI and any
instances that you launch from the AMI.

This option is supported only for HVM AMIs. Specifying this option with
a PV AMI can make instances launched from the AMI unreachable.
}

\section{KernelId}{

The ID of the kernel.
}

\section{BillingProduct}{

The
billing product codes. Your account must be authorized to specify
billing product codes. Otherwise, you can use the AWS Marketplace to
bill for the use of an AMI.
}

\section{RamdiskId}{

The ID of the RAM
disk.
}

\section{RootDeviceName}{

The device name of the root device volume (for
example, \verb{/dev/sda1}).
}

\section{SriovNetSupport}{


Set to \code{simple} to enable enhanced networking with the Intel 82599
Virtual Function interface for the AMI and any instances that you launch
from the AMI.

There is no way to disable \code{sriovNetSupport} at this time.

This option is supported only for HVM AMIs. Specifying this option with
a PV AMI can make instances launched from the AMI unreachable.
}

\section{VirtualizationType}{


The type of virtualization (\code{hvm} \| \code{paravirtual}).

Default: \code{paravirtual}
}

