% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_volume}
\alias{ec2_create_volume}
\title{Create Volume}
\usage{
ec2_create_volume(
  AvailabilityZone,
  Encrypted = NULL,
  Iops = NULL,
  KmsKeyId = NULL,
  OutpostArn = NULL,
  Size = NULL,
  SnapshotId = NULL,
  VolumeType = NULL,
  DryRun = NULL,
  TagSpecification = NULL,
  MultiAttachEnabled = NULL,
  Throughput = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{AvailabilityZone}{Character. The Availability Zone in which to create the volume.}

\item{Encrypted}{Logical.   Indicates whether the volume should be encrypted.[optional]}

\item{Iops}{Integer.   The number of I/O operations per second (IOPS).[optional]}

\item{KmsKeyId}{Character.   The identifier of the AWS Key Management Service (AWS KMS) customer master key (CMK) to use for...[optional]}

\item{OutpostArn}{Character. The Amazon Resource Name (ARN) of the Outpost.[optional]}

\item{Size}{Integer.   The size of the volume, in GiBs.[optional]}

\item{SnapshotId}{Character. The snapshot from which to create the volume.[optional]}

\item{VolumeType}{Character.   The volume type.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{TagSpecification}{List. The tags to apply to the volume during creation.[optional]}

\item{MultiAttachEnabled}{Logical. Indicates whether to enable Amazon EBS Multi-Attach.[optional]}

\item{Throughput}{Integer.   The throughput to provision for a volume, with a maximum of 1,000 MiB/s.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Create Volume
}
\section{AvailabilityZone}{

The Availability Zone in
which to create the volume.
}

\section{Encrypted}{


Indicates whether the volume should be encrypted. The effect of setting
the encryption state to \code{true} depends on the volume origin (new or from
a snapshot), starting encryption state, ownership, and whether
encryption by default is enabled. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default}{Encryption by default}
in the \emph{Amazon Elastic Compute Cloud User Guide}.

Encrypted Amazon EBS volumes must be attached to instances that support
Amazon EBS encryption. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances}{Supported instance types}.
}

\section{Iops}{


The number of I/O operations per second (IOPS). For \code{gp3}, \code{io1}, and
\code{io2} volumes, this represents the number of IOPS that are provisioned
for the volume. For \code{gp2} volumes, this represents the baseline
performance of the volume and the rate at which the volume accumulates
I/O credits for bursting.

The following are the supported values for each volume type:
\itemize{
\item \code{gp3}: 3,000-16,000 IOPS
\item \code{io1}: 100-64,000 IOPS
\item \code{io2}: 100-64,000 IOPS
}

For \code{io1} and \code{io2} volumes, we guarantee 64,000 IOPS only for
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances}{Instances built on the Nitro System}.
Other instance families guarantee performance up to 32,000 IOPS.

This parameter is required for \code{io1} and \code{io2} volumes. The default for
\code{gp3} volumes is 3,000 IOPS. This parameter is not supported for \code{gp2},
\code{st1}, \code{sc1}, or \code{standard} volumes.
}

\section{KmsKeyId}{


The identifier of the AWS Key Management Service (AWS KMS) customer
master key (CMK) to use for Amazon EBS encryption. If this parameter is
not specified, your AWS managed CMK for EBS is used. If \code{KmsKeyId} is
specified, the encrypted state must be \code{true}.

You can specify the CMK using any of the following:
\itemize{
\item Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
\item Key alias. For example, alias/ExampleAlias.
\item Key ARN. For example,
arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
\item Alias ARN. For example,
arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
}

AWS authenticates the CMK asynchronously. Therefore, if you specify an
ID, alias, or ARN that is not valid, the action can appear to complete,
but eventually fails.
}

\section{OutpostArn}{

The Amazon Resource Name (ARN) of the
Outpost.
}

\section{Size}{


The size of the volume, in GiBs. You must specify either a snapshot ID
or a volume size. If you specify a snapshot, the default is the snapshot
size. You can specify a volume size that is equal to or larger than the
snapshot size.

The following are the supported volumes sizes for each volume type:
\itemize{
\item \code{gp2} and \code{gp3}: 1-16,384
\item \code{io1} and \code{io2}: 4-16,384
\item \code{st1} and \code{sc1}: 125-16,384
\item \code{standard}: 1-1,024
}
}

\section{SnapshotId}{

The snapshot from which to create the volume. You
must specify either a snapshot ID or a volume size.
}

\section{VolumeType}{


The volume type. This parameter can be one of the following values:
\itemize{
\item General Purpose SSD: \code{gp2} \| \code{gp3}
\item Provisioned IOPS SSD: \code{io1} \| \code{io2}
\item Throughput Optimized HDD: \code{st1}
\item Cold HDD: \code{sc1}
\item Magnetic: \code{standard}
}

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html}{Amazon EBS volume types}
in the \emph{Amazon Elastic Compute Cloud User Guide}.

Default: \code{gp2}
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{TagSpecification}{

The tags to apply to the
volume during creation.
}

\section{MultiAttachEnabled}{

Indicates whether to enable
Amazon EBS Multi-Attach. If you enable Multi-Attach, you can attach the
volume to up to 16 \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances}{Instances built on the Nitro System}
in the same Availability Zone. This parameter is supported with \code{io1}
and \code{io2} volumes only. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volumes-multi.html}{Amazon EBS Multi-Attach}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}

\section{Throughput}{


The throughput to provision for a volume, with a maximum of 1,000 MiB/s.

This parameter is valid only for \code{gp3} volumes.

Valid Range: Minimum value of 125. Maximum value of 1000.
}

