% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_associate_vpc_cidr_block}
\alias{ec2_associate_vpc_cidr_block}
\title{Associate Vpc Cidr Block}
\usage{
ec2_associate_vpc_cidr_block(
  VpcId,
  AmazonProvidedIpv6CidrBlock = NULL,
  CidrBlock = NULL,
  Ipv6CidrBlockNetworkBorderGroup = NULL,
  Ipv6Pool = NULL,
  Ipv6CidrBlock = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{VpcId}{Character. The ID of the VPC.}

\item{AmazonProvidedIpv6CidrBlock}{Logical. Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC.[optional]}

\item{CidrBlock}{Character. An IPv4 CIDR block to associate with the VPC.[optional]}

\item{Ipv6CidrBlockNetworkBorderGroup}{Character.   The name of the location from which we advertise the IPV6 CIDR block.[optional]}

\item{Ipv6Pool}{Character. The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.[optional]}

\item{Ipv6CidrBlock}{Character.   An IPv6 CIDR block from the IPv6 address pool.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Associate Vpc Cidr Block
}
\section{VpcId}{

The ID of the
VPC.
}

\section{AmazonProvidedIpv6CidrBlock}{

Requests an Amazon-provided IPv6 CIDR block
with a /56 prefix length for the VPC. You cannot specify the range of
IPv6 addresses, or the size of the CIDR block.
}

\section{CidrBlock}{

An
IPv4 CIDR block to associate with the VPC.
}

\section{Ipv6CidrBlockNetworkBorderGroup}{


The name of the location from which we advertise the IPV6 CIDR block.
Use this parameter to limit the CIDR block to this location.

You must set \code{AmazonProvidedIpv6CidrBlock} to \code{true} to use this
parameter.

You can have one IPv6 CIDR block association per network border group.
}

\section{Ipv6Pool}{

The ID of an IPv6 address pool from which to
allocate the IPv6 CIDR block.
}

\section{Ipv6CidrBlock}{


An IPv6 CIDR block from the IPv6 address pool. You must also specify
\code{Ipv6Pool} in the request.

To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
}

