% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_delete_vpn_connection_route}
\alias{ec2_delete_vpn_connection_route}
\title{Delete Vpn Connection Route}
\usage{
ec2_delete_vpn_connection_route(
  DestinationCidrBlock,
  VpnConnectionId,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{DestinationCidrBlock}{Character. The CIDR block associated with the local subnet of the customer network.}

\item{VpnConnectionId}{Character. The ID of the VPN connection.}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Deletes the specified static route associated with
a VPN connection between an existing virtual private gateway and a VPN
customer gateway. The static route allows traffic to be routed from the
virtual private gateway to the VPN customer
gateway.
}
\section{DestinationCidrBlock}{

The CIDR block associated
with the local subnet of the customer network.
}

\section{VpnConnectionId}{

The
ID of the VPN connection.
}

