% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_transit_gateway_vpc_attachment}
\alias{ec2_modify_transit_gateway_vpc_attachment}
\title{Modify Transit Gateway Vpc Attachment}
\usage{
ec2_modify_transit_gateway_vpc_attachment(
  TransitGatewayAttachmentId,
  AddSubnetIds = NULL,
  RemoveSubnetIds = NULL,
  Options = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{TransitGatewayAttachmentId}{String. The ID of the attachment.}

\item{AddSubnetIds}{List. The IDs of one or more subnets to add. You can specify at most one subnet per Availability Zone.[optional]}

\item{RemoveSubnetIds}{List. The IDs of one or more subnets to remove.[optional]}

\item{Options}{Object.   The new VPC attachment options.  You cannot modify the IPv6 options.  [optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modifies the specified VPC
attachment.
}
\section{TransitGatewayAttachmentId}{

The ID of the
attachment.
}

\section{AddSubnetIds}{

The IDs of one or more subnets to add.
You can specify at most one subnet per Availability
Zone.
}

\section{RemoveSubnetIds}{

The IDs of one or more subnets to
remove.
}

\section{Options}{


The new VPC attachment options.

You cannot modify the IPv6 options.
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

