% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_enable_vpc_classic_link}
\alias{ec2_enable_vpc_classic_link}
\title{Enable Vpc Classic Link}
\usage{
ec2_enable_vpc_classic_link(
  VpcId,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{VpcId}{String. The ID of the VPC.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Enables a VPC for ClassicLink. You can
then link EC2-Classic instances to your ClassicLink-enabled VPC to allow
communication over private IP addresses. You cannot enable your VPC for
ClassicLink if any of your VPC route tables have existing routes for
address ranges within the \verb{10.0.0.0/8} IP address range, excluding local
routes for VPCs in the \verb{10.0.0.0/16} and \verb{10.1.0.0/16} IP address
ranges. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html}{ClassicLink}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{VpcId}{

The ID of the
VPC.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

