% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_volumes_modifications}
\alias{ec2_describe_volumes_modifications}
\title{Describe Volumes Modifications}
\usage{
ec2_describe_volumes_modifications(
  DryRun = NULL,
  VolumeId = NULL,
  Filter = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{VolumeId}{List. The IDs of the volumes.[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{MaxResults}{Integer. The maximum number of results (up to a limit of 500) to be returned in a paginated request.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describe Volumes Modifications
}
\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{VolumeId}{

The IDs of the
volumes.
}

\section{Filter}{


The filters.
\itemize{
\item \code{modification-state} - The current modification state (modifying \|
optimizing \| completed \| failed).
\item \code{original-iops} - The original IOPS rate of the volume.
\item \code{original-size} - The original size of the volume, in GiB.
\item \code{original-volume-type} - The original volume type of the volume
(standard \| io1 \| io2 \| gp2 \| sc1 \| st1).
\item \code{originalMultiAttachEnabled} - Indicates whether Multi-Attach
support was enabled (true \| false).
\item \code{start-time} - The modification start time.
\item \code{target-iops} - The target IOPS rate of the volume.
\item \code{target-size} - The target size of the volume, in GiB.
\item \code{target-volume-type} - The target volume type of the volume
(standard \| io1 \| io2 \| gp2 \| sc1 \| st1).
\item \code{targetMultiAttachEnabled} - Indicates whether Multi-Attach support
is to be enabled (true \| false).
\item \code{volume-id} - The ID of the volume.
}
}

\section{MaxResults}{

The maximum number of results (up
to a limit of 500) to be returned in a paginated
request.
}

