% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_transit_gateway_attachments}
\alias{ec2_describe_transit_gateway_attachments}
\title{Describe Transit Gateway Attachments}
\usage{
ec2_describe_transit_gateway_attachments(
  TransitGatewayAttachmentIds = NULL,
  Filter = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{TransitGatewayAttachmentIds}{List. The IDs of the attachments.[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{MaxResults}{Integer. The maximum number of results to return with a single call.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes one or more attachments
between resources and transit gateways. By default, all attachments are
described. Alternatively, you can filter the results by attachment ID,
attachment state, resource ID, or resource
owner.
}
\section{TransitGatewayAttachmentIds}{

The IDs of the
attachments.
}

\section{Filter}{


One or more filters. The possible values are:
\itemize{
\item \code{association.state} - The state of the association (\code{associating} \|
\code{associated} \| \code{disassociating}).
\item \code{association.transit-gateway-route-table-id} - The ID of the route
table for the transit gateway.
\item \code{resource-id} - The ID of the resource.
\item \code{resource-owner-id} - The ID of the AWS account that owns the
resource.
\item \code{resource-type} - The resource type. Valid values are \code{vpc} \| \code{vpn}
\| \code{direct-connect-gateway} \| \code{peering} \| \code{connect}.
\item \code{state} - The state of the attachment. Valid values are \code{available}
\| \code{deleted} \| \code{deleting} \| \code{failed} \| \code{failing} \|
\code{initiatingRequest} \| \code{modifying} \| \code{pendingAcceptance} \|
\code{pending} \| \code{rollingBack} \| \code{rejected} \| \code{rejecting}.
\item \code{transit-gateway-attachment-id} - The ID of the attachment.
\item \code{transit-gateway-id} - The ID of the transit gateway.
\item \code{transit-gateway-owner-id} - The ID of the AWS account that owns the
transit gateway.
}
}

\section{MaxResults}{

The maximum number of results to return with a
single call. To retrieve the remaining results, make another call with
the returned \code{nextToken} value.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

