% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_instance_export_task}
\alias{ec2_create_instance_export_task}
\title{Create Instance Export Task}
\usage{
ec2_create_instance_export_task(
  ExportToS3,
  InstanceId,
  TargetEnvironment,
  Description = NULL,
  TagSpecification = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{ExportToS3}{Object. The format and location for an export instance task.}

\item{InstanceId}{String. The ID of the instance.}

\item{TargetEnvironment}{String. The target virtualization environment.}

\item{Description}{String. A description for the conversion task or the resource being exported.[optional]}

\item{TagSpecification}{List. The tags to apply to the export instance task during creation.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create Instance Export Task
}
\section{ExportToS3}{

The format and location for an export instance
task.
}

\section{InstanceId}{

The ID of the
instance.
}

\section{TargetEnvironment}{

The target virtualization
environment.
}

\section{Description}{

A description for the conversion task
or the resource being exported. The maximum length is 255
characters.
}

\section{TagSpecification}{

The tags to apply to the export instance
task during creation.
}

