% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_cancel_spot_fleet_requests}
\alias{ec2_cancel_spot_fleet_requests}
\title{Cancel Spot Fleet Requests}
\usage{
ec2_cancel_spot_fleet_requests(
  SpotFleetRequestId,
  TerminateInstances,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{SpotFleetRequestId}{List. The IDs of the Spot Fleet requests.}

\item{TerminateInstances}{Logical. Indicates whether to terminate instances for a Spot Fleet request if it is canceled successfully.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Cancel Spot Fleet Requests
}
\section{SpotFleetRequestId}{

The IDs of the Spot
Fleet requests.
}

\section{TerminateInstances}{

Indicates whether to terminate
instances for a Spot Fleet request if it is canceled
successfully.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

