% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_network_interface}
\alias{ec2_create_network_interface}
\title{Create Network Interface}
\usage{
ec2_create_network_interface(
  SubnetId,
  Description = NULL,
  DryRun = NULL,
  SecurityGroupId = NULL,
  Ipv6AddressCount = NULL,
  Ipv6Addresses = NULL,
  PrivateIpAddress = NULL,
  PrivateIpAddresses = NULL,
  SecondaryPrivateIpAddressCount = NULL,
  InterfaceType = NULL,
  TagSpecification = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{SubnetId}{String. The ID of the subnet to associate with the network interface.}

\item{Description}{String. A description for the network interface.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{SecurityGroupId}{List. The IDs of one or more security groups.[optional]}

\item{Ipv6AddressCount}{Integer. The number of IPv6 addresses to assign to a network interface.[optional]}

\item{Ipv6Addresses}{List. One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet.[optional]}

\item{PrivateIpAddress}{String. The primary private IPv4 address of the network interface.[optional]}

\item{PrivateIpAddresses}{List. One or more private IPv4 addresses.[optional]}

\item{SecondaryPrivateIpAddressCount}{Integer.   The number of secondary private IPv4 addresses to assign to a network interface.[optional]}

\item{InterfaceType}{String. Indicates the type of network interface.[optional]}

\item{TagSpecification}{List. The tags to apply to the new network interface.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create Network Interface
}
\section{SubnetId}{

The ID of the subnet to
associate with the network interface.
}

\section{Description}{

A description
for the network interface.
}

\section{DryRun}{

Checks whether you have
the required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{SecurityGroupId}{

The IDs of one or more
security groups.
}

\section{Ipv6AddressCount}{

The number of IPv6 addresses to
assign to a network interface. Amazon EC2 automatically selects the IPv6
addresses from the subnet range. You can\'t use this option if
specifying specific IPv6 addresses. If your subnet has the
\code{AssignIpv6AddressOnCreation} attribute set to \code{true}, you can specify
\code{0} to override this setting.
}

\section{Ipv6Addresses}{

One or more specific
IPv6 addresses from the IPv6 CIDR block range of your subnet. You can\'t
use this option if you\'re specifying a number of IPv6
addresses.
}

\section{PrivateIpAddress}{

The primary private IPv4 address of the
network interface. If you don\'t specify an IPv4 address, Amazon EC2
selects one for you from the subnet\'s IPv4 CIDR range. If you specify
an IP address, you cannot indicate any IP addresses specified in
\code{privateIpAddresses} as primary (only one IP address can be designated
as primary).
}

\section{PrivateIpAddresses}{

One or more private IPv4
addresses.
}

\section{SecondaryPrivateIpAddressCount}{


The number of secondary private IPv4 addresses to assign to a network
interface. When you specify a number of secondary IPv4 addresses, Amazon
EC2 selects these IP addresses within the subnet\'s IPv4 CIDR range. You
can\'t specify this option and specify more than one private IP address
using \code{privateIpAddresses}.

The number of IP addresses you can assign to a network interface varies
by instance type. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI}{IP Addresses Per ENI Per Instance Type}
in the \emph{Amazon Virtual Private Cloud User Guide}.
}

\section{InterfaceType}{

Indicates the type of network interface. To create
an Elastic Fabric Adapter (EFA), specify \code{efa}. For more information,
see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html}{Elastic Fabric Adapter}
in the \emph{Amazon Elastic Compute Cloud User
Guide}.
}

\section{TagSpecification}{

The tags to apply to the new network
interface.
}

