% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_image}
\alias{ec2_create_image}
\title{Create Image}
\usage{
ec2_create_image(
  InstanceId,
  Name,
  BlockDeviceMapping = NULL,
  Description = NULL,
  DryRun = NULL,
  NoReboot = NULL,
  TagSpecification = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{InstanceId}{String. The ID of the instance.}

\item{Name}{String.   A name for the new image.}

\item{BlockDeviceMapping}{List. The block device mappings.[optional]}

\item{Description}{String. A description for the new image.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{NoReboot}{Logical. By default, Amazon EC2 attempts to shut down and reboot the instance before creating the image.[optional]}

\item{TagSpecification}{List.   The tags to apply to the AMI and snapshots on creation.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create Image
}
\section{InstanceId}{

The
ID of the instance.
}

\section{Name}{


A name for the new image.

Constraints: 3-128 alphanumeric characters, parentheses (()), square
brackets ([]), spaces ( ), periods (.), slashes (/), dashes (-),
single quotes (\'), at-signs (@), or underscores(_)
}

\section{BlockDeviceMapping}{

The block device mappings. This parameter cannot be
used to modify the encryption status of existing volumes or snapshots.
To create an AMI with encrypted snapshots, use the CopyImage
action.
}

\section{Description}{

A description for the new
image.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{NoReboot}{

By default, Amazon EC2
attempts to shut down and reboot the instance before creating the image.
If the \verb{No Reboot} option is set, Amazon EC2 doesn\'t shut down the
instance before creating the image. When this option is used, file
system integrity on the created image can\'t be
guaranteed.
}

\section{TagSpecification}{


The tags to apply to the AMI and snapshots on creation. You can tag the
AMI, the snapshots, or both.
\itemize{
\item To tag the AMI, the value for \code{ResourceType} must be \code{image}.
\item To tag the snapshots that are created of the root volume and of
other EBS volumes that are attached to the instance, the value for
\code{ResourceType} must be \code{snapshot}. The same tag is applied to all of
the snapshots that are created.
}

If you specify other values for \code{ResourceType}, the request fails.

To tag an AMI or snapshot after it has been created, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html}{CreateTags}.
}

