% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{aweSOMsmoothdist}
\alias{aweSOMsmoothdist}
\title{Smooth Distance Plot for SOM}
\usage{
aweSOMsmoothdist(
  som,
  pal = c("viridis", "grey", "rainbow", "heat", "terrain", "topo", "cm",
    rownames(RColorBrewer::brewer.pal.info)),
  reversePal = FALSE
)
}
\arguments{
\item{som}{\code{kohonen} object, a SOM created by the \code{kohonen::som} function.}

\item{pal}{character, the color palette. Default is "viridis". Can be
"viridis", "grey", "rainbow", "heat", "terrain", "topo", "cm", or any
palette name of the RColorBrewer package.}

\item{reversePal}{logical, whether color palette should be reversed. Default
is FALSE.}
}
\value{
No return value, called for side effects.
}
\description{
Plots a visualization of the distances between the SOM cells. Based on the
U-Matrix, which is computed for each cell as the mean distance to its
immediate neighbors.
}
\details{
Note: the resulting smooth distance plot is inexact for the
  hexagonal map layout.
}
\examples{
## Build training data
dat <- iris[, c("Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width")]
### Scale training data
dat <- scale(dat)
## Train SOM
### RNG Seed (for reproducibility)
### Initialization (PCA grid)
init <- somInit(dat, 4, 4)
ok.som <- kohonen::som(dat, grid = kohonen::somgrid(4, 4, 'rectangular'),
                       rlen = 100, alpha = c(0.05, 0.01),
                       radius = c(2.65,-2.65), init = init,
                       dist.fcts = 'sumofsquares')
aweSOMsmoothdist(ok.som)
}
