% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.avophylo}
\alias{plot.avophylo}
\title{Plot Model Fits for an 'avophylo' Object}
\usage{
\method{plot}{avophylo}(
  x,
  tips = "extinct",
  tips_col = NULL,
  order = NULL,
  family = NULL,
  genus = NULL,
  species = NULL,
  avotrex,
  tax,
  lvls = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class 'avophylo'.}

\item{tips}{What tip labels to present. Can be one of
"extinct" (just tip labels of extinct species), "none" (no
tip labels) or "all_same" (show all labels, with same colour
labels for all species), or "all_dif" (show all labels, with
different colour labels for extant and extinct species).
The latter needs to be used in combination with the
\code{tips_col} argument.}

\item{tips_col}{Colour of tip labels. If \code{tips =
"all_dif"} this needs to be a vector of length two, with the
first value being the colour for extinct species, and the
second for extant species.}

\item{order}{Prune the tree to only show a specific order
(should be a character vector of length = 1). Taxonomy
follows BirdTree, see the \code{data(BirdTree_taxa)} file.
For extinct order names, see the \code{data(AvotrexPhylo)}
file.}

\item{family}{As for \code{order}, but for families.}

\item{genus}{As for \code{order}, but for genera.}

\item{species}{Prune the tree to only show a specific set of
species. Should be a vector of at least length = 1. If only
a single species name is provided, the \code{lvls} argument
also needs to be provided.}

\item{avotrex}{The Avotrex phylo dataset used to generate the
trees. For most use cases, this will have been loaded using
\code{data(AvotrexPhylo)}.}

\item{tax}{The Jetz et al. (2012) BirdTree taxonomy .csv.
Supplied as data within the package.}

\item{lvls}{If \code{species} is just a single species, how
many levels back (rootward) should be plotted. Uses the
\code{tidytree::tree_subset} function (see help
documentation of that function for further info).}

\item{\dots}{Other plotting arguments from the ape package's
\link[ape]{plot.phylo} can be provided.}
}
\value{
Generates a phylogeny plot of \code{x}.
}
\description{
S3 method for class 'avophylo'.
  \code{plot.avophylo} creates plots for objects of class
  'avophylo'. The exact plot(s) constructed depends on the
  argument values provided (see examples below and also the
  package vignette). The function uses the ape package's
  \link[ape]{plot.phylo} and can take any argument from that
  function (e.g. the \code{type} argument).

  If \code{\link{AvoPhylo}} is used to produce a list of trees
  of class 'multiAvophylo', then \code{plot.multiAvophylo} is
  first called. This plots individual trees in turn (with the
  user required to press 'enter' to move to the next plot).

  The user will need to play around with plotting
  window size, and/or export the image, particularly if many
  tips are included.
  
  Note - if using the \code{lvls} argument, a warning is
  provided. This comes from the \code{tidytree::tree_subset}
  function and appears to be a bug (but the plot should be
  checked for sense).
}
\examples{
# Generate a set of trees
# data(BirdTree_trees)
# data(BirdTree_tax)
# data(AvotrexPhylo)
# trees <- AvoPhylo(ctrees = BirdTree_trees,
# avotrex = AvotrexPhylo, PER = 0.2, PER_FIXED = 0.75,
# tax = BirdTree_tax, Ntree = 2, n.cores = 2, 
# cluster.ips = NULL)

#For here, we can load in an example set of two trees 
#generated using the above code

data(treesEx)

#order (owls) - just show extinct tip names (in red) and using
#a fan plot
plot(treesEx[[1]], avotrex = AvotrexPhylo, tax = BirdTree_tax,
     order = "Strigiformes", tips = "extinct",
     type = "fan", tip.color = "red", cex = 0.4)

#family (plot all three trees this time)
plot(treesEx, avotrex = AvotrexPhylo, tax = BirdTree_tax,
     family = "Threskiornithidae", tips = "extinct",
     tip.color = "red", cex = 0.5)

#genus - cladogram plot
plot(treesEx[[2]], avotrex = AvotrexPhylo, tax = BirdTree_tax,
     genus = "Aplonis", tips = "extinct",
     type = "cladogram",
     tip.color = "red", cex = 0.5)

#species (& show all tip names in same colour)
species2 <- c("Anas_itchtucknee", "Anas_sp_VitiLevu",
              "Anas_platyrhynchos", "Ara_tricolor")

plot(treesEx[[2]], avotrex = AvotrexPhylo, tax = BirdTree_tax,
     species = species2, tips = "all_same",
     type = "cladogram",
     tip.color = "blue", cex = 0.5)

#same as previous, but extinct and extant diff colours
plot(treesEx[[2]], avotrex = AvotrexPhylo, tax = BirdTree_tax,
     species = species2,
     cex = 0.5, tips = "all_dif",
     tips_col = c("red", "darkgreen"),
     type = "cladogram")

##single species 2 levels back
plot(treesEx[[2]], avotrex = AvotrexPhylo, tax = BirdTree_tax,
     species = "Ara_tricolor",
     tips = "all_dif",
     tips_col = c("red", "darkgreen"),
     lvls = 2,
     type = "phylogram",
     cex = 0.6)
}
