% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/av_processes.R
\name{av_rw}
\alias{av_rw}
\title{Calculate Theoretical Allan Variance for Random Walk Process}
\usage{
av_rw(omega2, n)
}
\arguments{
\item{omega2}{A \code{double} value for the noise parameter \eqn{\omega ^2}{omega^2}.}

\item{n}{An \code{integer} value for the size of the cluster.}
}
\value{
A \code{double} indicating the theoretical allan variance for the random walk
process.
}
\description{
This function allows us to calculate the theoretical allan variance for
random walk process.
}
\note{
This function is based on the calculation of the theoretical allan variance
for random walk process raised in "Allan Variance of Time Series Models for
Measurement Data" by Nien Fan Zhang, 2008, Metrologia, 45(5): 549.
This calculation is fundamental and necessary for the study in "A Study of the Allan Variance
for Constant-Mean Non-Stationary Processes" by Xu et al., 2017, IEEE Signal Processing Letters, 24(8): 1257–1260.
}
\examples{
av1 = av_rw(omega2 = 1, n = 5)
av2 = av_rw(omega2 = 2, n = 8)
}
