% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack_thresh.R
\name{med_stack_thresh}
\alias{med_stack_thresh}
\title{Threshold every image frame in a stack based on their median.}
\usage{
med_stack_thresh(arr3d, method, fail = NA, ignore_black = FALSE,
  ignore_white = FALSE)
}
\arguments{
\item{arr3d}{A 3-dimensional array (the image stack) where the \eqn{n}th
slice is the \eqn{n}th image in the time series.}

\item{method}{The thresholding method to use. See
[autothresholdr::auto_thresh].}

\item{fail}{To which value should pixels not exceeeding the threshold be set?}

\item{ignore_black}{Ignore black pixels/elements (zeros) when performing the
thresholding?}

\item{ignore_white}{Ignore white pixels when performing the thresholding? If
set to \code{TRUE}, the function makes a good guess as to what the white
(saturated) value would be (see "Details"). If this is set to a number, all
pixels with value greater than or equal to that number are ignored.}
}
\value{
A 3d array, the thresholded stack. Pillars not exceeding the
  threshold are set to zero. The attribute 'threshold' gives the value used
  for thresholding.
}
\description{
This function finds a threshold based on all of the frames, then takes the
median of all the frames in the stack image, uses this to create a mask
and then applies this mask to every frame in the stack (so for a given pillar
in the image stack, either all the pixels therein are thresholded away, all
are untouched).
}
\details{
\itemize{ \item{\code{NA} values are automatically ignored.} \item{For
\code{ignore.white = TRUE}, if the maximum value in the array is one of
\code{2^8-1}, \code{2^12-1}, \code{2^16-1} or \code{2^32-1}, then those max
values are ignored. That's because they're the white values in 8, 12, 16 and
32-bit images respectively (and these are the common image bit sizes to work
with). This guesswork has to be done because \code{R} does not know how many
bits the image was on disk. This guess is very unlikely to be wrong, and if
it is, the consequences are negligible anyway. If you're very concerned, then
just specify the max value in the \code{ignore.white} argument.} \item{If you
have set \code{ignore.black = TRUE} and/or \code{ignore.white = TRUE} but you
are still getting error/warning messages telling you to try them, then your
chosen method is not working for the given array, so you should try a
different method.} }
}
\examples{
library(EBImage)
img <- imageData(readImage(system.file('extdata', '50.tif',
                                       package = 'autothresholdr'),
                           as.is = TRUE))
display(normalize(img[, , 1]), method = 'raster')
img_thresh_mask <- mean_stack_thresh(img, 'Otsu')
display(img_thresh_mask[, , 1] > 0, method = 'r')
display(normalize(img[, , 1]), method = 'raster')
img_thresh_mask <- med_stack_thresh(img, 'Triangle')
display(img_thresh_mask[, , 1] > 0, method = 'r')

}
