% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{MeanPillars}
\alias{MeanPillars}
\alias{VarPillars}
\alias{MedianPillars}
\title{Get the means/medians/variances of pillars of a 3d array}
\usage{
MeanPillars(mat3d)

VarPillars(mat3d)

MedianPillars(mat3d)
}
\arguments{
\item{mat3d}{A 3-dimensional array.}
}
\value{
A matrix where element \code{i,j} is equal to \code{mean(mat3d[i, j, ])},
\code{median(mat3d[i, j, ])}, or \code{var(mat3d[i, j, ])}.
}
\description{
For a 3-dimensional array \code{mat3d}, pillar \code{ij} is defined as
\code{mat3d[i, j, ]}. These functions compute the mean, median and variance of each
pillar.
}
\examples{
m3 <- array(1:16, dim = c(2, 2, 4))
MeanPillars(m3)
MedianPillars(m3)
VarPillars(m3)

}
