% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPLE_summary.R
\name{MPLE_summary}
\alias{MPLE_summary}
\title{Summarize MPLE fits}
\usage{
MPLE_summary(fit)
}
\arguments{
\item{fit}{a fitted MPLE object}
}
\value{
tables based on the model fit
}
\description{
Prints out summary tables of fitted model objects from MPLE. Also
returns knitr::kable() summary tables.
}
\examples{

##########generating model fit to summarize
#adjacency matrix A
A=igraph::get.adjacency(igraph::make_lattice(c(40,40)))
X=cbind(rep(1,1600),matrix(rnorm(1600*4),ncol=4))
gamma=0.6
beta=matrix(rnorm(5)*0.3,ncol=1)
y=drawSamples(beta,gamma,X,A,burnIn=10,nSamples=1)
fit=MPLE(X = X,y=factor(y),A = A,ciLevel = 0.99,method = "asymptotic")
##########

##########summarizing model fit
MPLE_summary(fit)

}
