% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppolygon.R
\name{ppolygon}
\alias{ppolygon}
\title{Projected polygon function}
\usage{
ppolygon(x, y = NULL, proj, ...)
}
\arguments{
\item{x}{vectors containing the coordinates of the vertices
    of the polygon.}

\item{y}{Locations of grid points at which the values in \code{z}
are measured.  The values must be finite and non-missing.  These 
arguments can be either vectors or matrices depending on the type
of data to be displayed.  See Details.}

\item{proj}{A character string indicating what projection should be
used for the included \code{x} and \code{y} coordinates.  The 
default is \code{"none"}.  The other valid choices correspond to 
the \code{"projection"} argument in the 
\code{\link[mapproj]{mapproject}} function, which is used for the
projection.}

\item{...}{graphical parameters such as \code{xpd}, \code{lend},
    \code{ljoin} and \code{lmitre} can be given as arguments.}
}
\description{
\code{ptext} draws polygons using the vertices given in \code{x} 
and \code{y}, possibly with projected coordinates.
}
\details{
The \code{\link[mapproj]{mapproject}} function is used for 
projection.
}
\examples{
data(narccap)
# plot image using bonne projection (w/o grid lines)
pimage(lon, lat, tasmax[,,1], proj = "bonne",
       parameters = 40, paxes.args = list(col = "grey"))
# filled polygon for Colorado border
data(copoly)
ppolygon(copoly, proj = "bonne", col = "orange")
}
\seealso{
\code{\link[graphics]{polygon}}, 
  \code{\link[mapproj]{mapproject}}, 
  \code{\link[autoimage]{pimage}}
}

