% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imphdsurv.R
\name{imphdsurv}
\alias{imphdsurv}
\title{High dimensional missing data imputation and survival analysis using survMCmulti with mediation analysis}
\usage{
imphdsurv(m, n, Surv, Event, time, ths, chn, i, adp, b, d, data)
}
\arguments{
\item{m}{Starting column number from where high dimensional variates to be selected.}

\item{n}{Ending column number till where high dimensional variates to be selected.}

\item{Surv}{"Column/Variable name" consisting duration of survival.}

\item{Event}{"Column/Variable name" consisting survival event.}

\item{time}{"Column/Variable name" consisting time of repeated observations.}

\item{ths}{A numeric between 0 to 100.}

\item{chn}{Number of MCMC chains to perform survival analysis.}

\item{i}{Number of MCMC iterations to perform survival analysis.}

\item{adp}{Number of MCMC adaptations to perform survival analysis.}

\item{b}{Number of MCMC iterations to burn.}

\item{d}{Number of draws.}

\item{data}{High dimensional data containing survival observations with multiple covariates.}
}
\value{
Data frame containing the beta and alpha values of active variables among the significant variables.
}
\description{
Given the dimension of variables and survival information the function
performs imputations using missForest function and filters significant variables,
allowing the user to do survival analysis with higher number of iterations. Further, it performs mediation
analysis among the significant variables and provides handful variables with their alpha.a values
which are mediator model exposure coefficients and beta.a coefficients.
}
\details{
High dimensional missing data imputation and performing mediation analysis using survMCmulti. It works in a multivariate setup.
}
\examples{
##
\dontrun{
imphdsurv(m=11,n=25,Surv="OS",Event="event",time="Visit",ths=0.02,chn=6,i=10,
          adp=100,b=10,d=10,data=srdata)
##
}
}
