% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer_info.R
\name{layer_info}
\alias{layer_info}
\alias{layer_info.default}
\alias{layer_info.ggplot}
\title{Data List}
\usage{
layer_info(p, keep = TRUE, ...)

\method{layer_info}{default}(p, keep = TRUE, ...)

\method{layer_info}{ggplot}(p, keep = TRUE, ...)
}
\arguments{
\item{p}{plot object}

\item{keep}{boolean vector (size = 1 or length(plot$layers)). Determines if that layer should have cognostics calculated}

\item{...}{parameters passed on to corresponding \code{layer_info}}
}
\description{
Data List
}
\examples{
require(ggplot2)
p <- ggplot(iris, aes(Sepal.Length, Sepal.Width)) +
  geom_point(data = mpg, mapping = aes(cty, hwy))
layer_info(p)
}
